
#ifndef __MAINFORM_HXX__
#define __MAINFORM_HXX__

#include "DraggableModalForm.hxx"

class MainForm : public DraggableModalForm {
public:
	MainForm( const PointType& pos, FieldType* pField );
//	~MainForm( );

public:
	UInt16 DoModal( );

private:
	bool PreSystemEventHook( EventType* pEvent );

private:
	BEGIN_PRE_EVENT_MAP(DraggableModalForm)
	END_PRE_EVENT_MAP()

	BEGIN_EVENT_MAP(DraggableModalForm)
		EVENT_MAP_ENTRY(keyDownEvent, OnKeyDown)
		EVENT_MAP_ENTRY(frmOpenEvent, OnOpen)
		EVENT_MAP_ENTRY(frmCloseEvent, OnClose)
		EVENT_MAP_COMMAND_ENTRY(DOUBLECHAR_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(SINGLECHAR_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(CAPITALCHAR_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(SMALLCHAR_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(HIRAGANA_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(KATAKANA_BUTTON,	OnButtonPressed)
		EVENT_MAP_COMMAND_ENTRY(UNDO_BUTTON,		OnUndo)
		EVENT_MAP_COMMAND_ENTRY(CLOSE_BUTTON,		OnCloseButton)
	END_EVENT_MAP()


	BEGIN_POST_EVENT_MAP(DraggableModalForm)
	END_POST_EVENT_MAP()

private:	// event handler
	bool OnOpen( EventType* pEvent );
	bool OnClose( EventType* pEvent );
	bool OnKeyDown( EventType* pEvent );
	bool OnButtonPressed( EventType* pEvent );
	bool OnCloseButton( EventType* pEvent );
	bool OnUndo( EventType* pEvent );

private:
	static bool DraggingCheck( const RectangleType& pRect, Coord x, Coord y );

private:
	struct UndoInfo {
		char* 		pData;
		UndoInfo*	pNext;
	};

private:
	FieldType*	m_pField;
	UndoInfo*	m_pUndoInfo;

};

#endif // __MAINFORM_HXX__
