/*
 * FortuneDA.c
 *
 * main file for FortuneDA
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */

#include <PalmOS.h>
#include <PalmOSGlue.h>

#include "FortuneDAPP.h"
#include "FortuneDAPP_Rsc.h"

#include "MainForm.hxx"


// preference
typedef struct _prefs {
	PointType lastTopLeft;
} PrefData;



// Function prototype ====================================================
extern "C" { void DAMain( ); }
//static Err GetCurAppName( char* name );
static void LoadPrefs( PrefData* pPref );
static void SavePrefs( PrefData* pPref );



// Entry point ===========================================================
extern "C" {

void DAMain( ) {

	UInt32 feature = 0;

	// ( Fortune DA ) DA ̓dNoB
	if( FtrGet( CREATORID, 0, &feature ) == 0 )
		return;									// ł Fortune DA NĂ -- dN
	else
		FtrSet( CREATORID, 0, feature );		// dN邽߂ɃtB[`[o^

	PrefData pref;

	// ȑONꂽƂ Preference [h
	LoadPrefs( &pref );

	MainForm theForm( pref.lastTopLeft );
	theForm.DoModal( );

	// AvP[V̏I
	theForm.GetLastPosition( pref.lastTopLeft );
	SavePrefs( &pref );

	// tB[`[
	if( FtrGet( CREATORID, 0, &feature ) == 0 )
		FtrUnregister( CREATORID, 0 );

}

}	// end of extern "C"

//========================================================================

// ẽAvP[V擾 ...  DA ł͖gp
//static Err GetCurAppName( char* name ) {
//	UInt16 cardNo;
//	LocalID dbID;
//	Err error = ::SysCurAppDatabase( &cardNo, &dbID );
//	if( !error )
//		error = DmDatabaseInfo( cardNo, dbID, name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
//	return error;
//}



// vt@Xǂݍ
static void LoadPrefs( PrefData* pPref ) {
	UInt16	prefSize;
	Int16	version = ::PrefGetAppPreferences( CREATORID, PREFERENCEID, pPref, &prefSize, true );
	if( version == noPreferenceFound ) {
		::MemSet( pPref, sizeof(PrefData), 0L );
		pPref->lastTopLeft.x = DefaultFrameXPos;
		pPref->lastTopLeft.y = DefaultFrameYPos;
	} else {
		switch( version ) {
		default:
			;
		}
	}
}

// vt@Xۑ
static void SavePrefs( PrefData* pPref ) {
	::PrefSetAppPreferences( CREATORID, PREFERENCEID,
							 PREFERENCEVERSION, pPref, sizeof(PrefData), true );
}

