/*
 * FortuneDA.c
 *
 * main file for FortuneDA
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */
 
#include <PalmOS.h>
#include <PalmOSGlue.h>

#include "Defs.h"


#define	JAPANESE_FORTUNE	1


// preference
typedef struct _prefs {
    Coord lastX;
    Coord lastY;
} PrefData;
    

// global variable
typedef struct _global {
    PrefData	prefs;
    Coord		fromX;
    Coord		fromY;
    Boolean		moving;
    MemHandle	fortuneHandle;
    char		fortune[FORTUNECNT][MaxFortuneChars];
} GlobalData;


/* Function prototype ====================================================*/
void DAMain( );
static Err GetCurAppName( char* name );
static void* GetObjectPtr( int objectID );
static void InitPrefs( GlobalData* pGlobal );
static void LoadPrefs( GlobalData* pGlobal );
static void SavePrefs( GlobalData* pGlobal );
static GlobalData* InitializeGlobalData( );
static void InitFortune( GlobalData* pGlobal );
static void ShowFortune( FieldPtr field, GlobalData* pGlobal );
static Boolean IsInside( RectanglePtr r, Coord x, Coord y );
static void ExorFrame( UInt16 topLeftX, UInt16 topLeftY );
static Boolean DAHandleEvent( EventPtr event, GlobalData* pGlobal );
static void RecalcFormLayout( EventPtr pEvent, RectangleType* pRect, GlobalData* pGlobal );
static void EventLoop( GlobalData* pGlobal );




/* Entry point ===========================================================*/
void DAMain( ) {

    GlobalData*		pGlobal = NULL;
    FormPtr			pForm;
    FieldPtr		pField;
    UInt32			feature = 0;
    RectangleType	rect;

    /* ( Fortune DA ) DA ̓dNoB*/
    if( FtrGet( CREATORID, 0, &feature ) == 0 )
		return;									/* ł Fortune DA NĂ -- dN */
	else
		FtrSet( CREATORID, 0, feature );		/* dN邽߂ɃtB[`[o^ */


    /* O[oϐ̈̊蓖ĂƂ̏ */
    pGlobal = InitializeGlobalData( );
    if( !pGlobal )
		return;			/* O[oϐ̈̊蓖ĂɎs */


    /* ȑONꂽƂ Preference [h */
    LoadPrefs( pGlobal );
    

    /* CtH[N */
    pForm = FrmInitForm( IdDAForm );

    /* ŌɋNꂽʒu𕜌 */
	WinGetBounds( FrmGetWindowHandle( pForm ), &rect );
    rect.topLeft.x = pGlobal->prefs.lastX;
    rect.topLeft.y = pGlobal->prefs.lastY;
    pGlobal->fromX = rect.topLeft.x;
    pGlobal->fromY = rect.topLeft.y;
    WinSetBounds( FrmGetWindowHandle( pForm ), &rect );
    FrmSetActiveForm( pForm );
    FrmDrawForm( pForm );

    /* _̏ */
    InitFortune( pGlobal );

    /* _̕\ */
    pField = GetObjectPtr( IdFortuneField );
    ShowFortune( pField, pGlobal );

    /* Cxgnh[ɐn */
    EventLoop( pGlobal );

    /* AvP[V̏I */
    pField = GetObjectPtr( IdFortuneField );
    FldSetTextHandle( pField, NULL );
    if( pGlobal->fortuneHandle != NULL )
		MemHandleFree( pGlobal->fortuneHandle );
    pGlobal->fortuneHandle = NULL;
    SavePrefs( pGlobal );
    FrmEraseForm( pForm );
    FrmDeleteForm( pForm );

    /* tB[`[ */
    if( FtrGet( CREATORID, 0, &feature ) == 0 )
		FtrUnregister( CREATORID, 0 );

    /* O[oϐ̈ */
    MemPtrFree( pGlobal );

}


/*========================================================================*/

/* ẽAvP[V擾 ...  DA ł͖gp */
static Err GetCurAppName( char* name ) {
    Err error;
    UInt16 cardNo;
    LocalID dbID;
    error = SysCurAppDatabase( &cardNo, &dbID );
    if( !error )
		error = DmDatabaseInfo( cardNo, dbID, name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
    return error;
}

static void* GetObjectPtr( int objectID ) {
    FormPtr form;
    UInt16  index;
    void*	ptr;
    form  = FrmGetActiveForm( );
    index = FrmGetObjectIndex( form, objectID );
    ptr   = FrmGetObjectPtr( form, index );
    return ptr;
}


/* Preference ̏ */
static void InitPrefs( GlobalData* pGlobal ) {
    MemSet( &pGlobal->prefs, sizeof(PrefData), 0L );
    pGlobal->prefs.lastX = DefaultFrameXPos;
    pGlobal->prefs.lastY = DefaultFrameYPos;
}


/* vt@Xǂݍ */
static void LoadPrefs( GlobalData* pGlobal ) {
    Int16	version;
    UInt16	prefSize;
    version = PrefGetAppPreferences( CREATORID, PREFERENCEID, &pGlobal->prefs, &prefSize, true );
    if( version == noPreferenceFound ) {
		InitPrefs( pGlobal );
    } else {
		switch( version ) {
		default:
			;
		}
    }
}

/* vt@Xۑ */
static void SavePrefs( GlobalData* pGlobal ) {
    PrefSetAppPreferences( CREATORID, PREFERENCEID,
						   PREFERENCEVERSION, &pGlobal->prefs, sizeof(pGlobal->prefs), true );
}

/* O[oϐ */
static GlobalData* InitializeGlobalData( ) {
    GlobalData* pGlobal;
    pGlobal = MemPtrNew( sizeof(GlobalData) );
    if( !!pGlobal ) {
	    pGlobal->moving = false;
	    pGlobal->fortuneHandle = NULL;
	}
    return pGlobal;
}

static void InitFortune( GlobalData* pGlobal ) {
#if defined(JAPANESE_FORTUNE)
    StrCopy( pGlobal->fortune[0], "[[A͂!" );
    StrCopy( pGlobal->fortune[1], "Ƃ邩..." );
    StrCopy( pGlobal->fortune[2], "bL[J[͗ΐF!" );
    StrCopy( pGlobal->fortune[3], "bL[J[͏M̐!" );
    StrCopy( pGlobal->fortune[4], "CɍU߂悤!" );
    StrCopy( pGlobal->fortune[5], "iɒ!" );
    StrCopy( pGlobal->fortune[6], "ȂɈȂ!" );
    StrCopy( pGlobal->fortune[7], "񂲂!!" );
#else
    StrCopy( pGlobal->fortune[0], "Good day!" );
    StrCopy( pGlobal->fortune[1], "Bad day!" );
    StrCopy( pGlobal->fortune[2], "Lucky color is green!" );
    StrCopy( pGlobal->fortune[3], "Lucky color is passion red!" );
    StrCopy( pGlobal->fortune[4], "Be aggressive!" );
    StrCopy( pGlobal->fortune[5], "Be careful of your boss!" );
    StrCopy( pGlobal->fortune[6], "Not too bad" );
    StrCopy( pGlobal->fortune[7], "Veeeryyy well!" );
#endif
}

static void ShowFortune( FieldPtr pField, GlobalData* pGlobal ) {
    char* p;
    pGlobal->fortuneHandle = MemHandleNew( MaxFortuneChars );
    p = MemHandleLock( pGlobal->fortuneHandle );
    StrCopy( p, pGlobal->fortune[SysRandom( TimGetTicks( ) ) % FORTUNECNT] );
    MemHandleUnlock( pGlobal->fortuneHandle );
    FldSetTextHandle( pField, (MemHandle)pGlobal->fortuneHandle );
    FldDrawField( pField );
}

/*  DA ̃tH[̓Ń^bvꂽ? */
static Boolean IsInside( RectanglePtr pRect, Coord x, Coord y ) {
  return ( 0 <= x && x <= pRect->extent.x && 0 <= y && y <= pRect->extent.y );
}

/* t[ EX-OR [hŕ` */
static void ExorFrame( UInt16 topLeftX, UInt16 topLeftY ) {
    RectangleType rect;
    rect.topLeft.x = topLeftX + 2;
    rect.topLeft.y = topLeftY + 2;
    rect.extent.x  = FrameXSize - 4;
    rect.extent.y  = FrameYSize - 4;
    WinInvertRectangleFrame( boldRoundFrame, &rect );
}

/* Cxgnh[ */
static Boolean DAHandleEvent( EventPtr pEvent, GlobalData* pGlobal ) {

    Boolean	done = false;
    Boolean	handled = false;
    FormPtr	form;
	RectangleType rect;

    switch( pEvent->eType ) {

    case appStopEvent:
		/* appStopEvent AƂ̃AvP[Vɑ */
		EvtAddEventToQueue( pEvent );
		done = true;
		handled = true;
		break;

    case keyDownEvent:
		if( TxtCharIsHardKey( pEvent->data.keyDown.modifiers, pEvent->data.keyDown.chr ) ) {
		    /* HotSync! {^ꂽ? */
		    EvtAddEventToQueue( pEvent );
		    done = true;
		    handled = true;
		}
		break;

    case penDownEvent:    /* ȉ́AhbKu@\̎ */
		form = FrmGetActiveForm( );
		WinGetBounds( FrmGetWindowHandle( form ), &rect );
		if( IsInside( &rect, pEvent->screenX, pEvent->screenY ) ) {
		    /* hbOJn */
		    pGlobal->fromX  = rect.topLeft.x + pEvent->screenX;
		    pGlobal->fromY  = rect.topLeft.y + pEvent->screenY;
		    pGlobal->moving = true;
		    FrmEraseForm( form );
		    /* hbÓAg\ */
		    ExorFrame( rect.topLeft.x, rect.topLeft.y );
		} else {
		    done = true;    /* tH[̊OŃ^bvꂽ -- I */
		}
	    handled = true;
		break;

    case penMoveEvent:
		if( pGlobal->moving ) {
		    form = FrmGetActiveForm( );
			WinGetBounds( FrmGetWindowHandle( form ), &rect );
	
		    /* Oɕ`悵g */
		    ExorFrame( rect.topLeft.x, rect.topLeft.y );
	
		    /* VtH[ʒuvZ */
			RecalcFormLayout( pEvent, &rect, pGlobal );
			WinSetBounds( FrmGetWindowHandle( form ), &rect );
	
		    /* Vg\ */
		    ExorFrame( rect.topLeft.x, rect.topLeft.y );
		    handled = true;
		}
		break;

    case penUpEvent:
		if( pGlobal->moving ) {
			form = FrmGetActiveForm( );
			WinGetBounds( FrmGetWindowHandle( form ), &rect );
		    /* ȑO̘g */
		    ExorFrame( rect.topLeft.x, rect.topLeft.y );

		    /* VtH[ʒuvZ */
			RecalcFormLayout( pEvent, &rect, pGlobal );
			WinSetBounds( FrmGetWindowHandle( form ), &rect );
	
		    /* vt@XɁAŌ̈ʒuL^ */
		    pGlobal->prefs.lastX = rect.topLeft.x;
		    pGlobal->prefs.lastY = rect.topLeft.y;
		    pGlobal->moving = false;
		    FrmDrawForm( form );
		    handled = true;
		}
		break;

    default:
		break;

    }

    if( !handled )
		FrmHandleEvent( FrmGetActiveForm( ), pEvent );

    return done;

}

/* hbOptH[ʒuČvZ */
static void RecalcFormLayout( EventPtr pEvent, RectangleType* pRect, GlobalData* pGlobal ) {
    Coord	moveX = pEvent->screenX - pGlobal->fromX;
	Coord	moveY = pEvent->screenY - pGlobal->fromY;
    pRect->topLeft.x += moveX;
    pRect->topLeft.y += moveY;
    if( pRect->topLeft.x < 0 )
    	pRect->topLeft.x = 0;
    if( pRect->topLeft.x + FrameXSize > 160 )
    	pRect->topLeft.x = 160 - FrameXSize;
    if( pRect->topLeft.y < 0 )
    	pRect->topLeft.y = 0;
    if( pRect->topLeft.y + FrameYSize > 160 )
    	pRect->topLeft.y = 160 - FrameYSize;
    pGlobal->fromX = pEvent->screenX;
    pGlobal->fromY = pEvent->screenY;
}

/* Cxg[v */
static void EventLoop( GlobalData* pGlobal ) {

    EventType	event;
    Boolean		done = false;
    UInt16		error;

    do {
		EvtGetEvent( &event, evtWaitForever );
		if( SysHandleEvent( &event ) )
		    continue;
		if( MenuHandleEvent( NULL, &event, &error ) )
		    continue;
		done = DAHandleEvent( &event, pGlobal );
    } while ( !done );

}

